#!/bin/bash
set -e

TEMPLATE_URL="https://cloud-images.ubuntu.com/plucky/current/plucky-server-cloudimg-amd64.img"
VMID=9000
TEMPLATE_NAME="ubuntu-25.04-cloudimg-temp"
STORAGE="local-lvm"
SSH_KEYS=$(curl -s https://gist.vorpax.dev/vorpax/ssh/raw/HEAD/ssh-keys.pub)

# positional args first (optional)
[ -n "$1" ] && VMID="$1"
[ -n "$2" ] && TEMPLATE_NAME="$2"
[ -n "$3" ] && STORAGE="$3"

# overrides (still optional)
while [[ $# -gt 3 ]]; do
    shift
    case "$1" in
        --vmid=*) VMID="${1#*=}" ;;
        --template=*) TEMPLATE_NAME="${1#*=}" ;;
        --storage=*) STORAGE="${1#*=}" ;;
    esac
done

cd /tmp
wget -O "${TEMPLATE_NAME}_disk" "$TEMPLATE_URL"

qm create "$VMID" \
  --name "$TEMPLATE_NAME" \
  --memory 3072 \
  --cores 3 \
  --net0 virtio,bridge=vmbr0 \
  --serial0 socket \
  --vga serial0

qm importdisk "$VMID" "${TEMPLATE_NAME}_disk" "$STORAGE"

# Créer le dossier des clés SSH
SSH_KEYS_DIR="ssh_keys_${VMID}"
mkdir -p "$SSH_KEYS_DIR"

# Écrire chaque clé dans un fichier unique
KEY_INDEX=0
while IFS= read -r key; do
    [ -z "$key" ] && continue
    SSH_KEY_FILE="${SSH_KEYS_DIR}/key_$(date +%s)_${KEY_INDEX}.pub"
    echo "$key" > "$SSH_KEY_FILE"
    qm set "$VMID" --sshkey "$SSH_KEY_FILE"
    ((KEY_INDEX++))
done <<< "$SSH_KEYS"

qm set "$VMID" \
  --scsihw virtio-scsi-pci \
  --scsi0 "${STORAGE}:vm-${VMID}-disk-0" \
  --ide2 "${STORAGE}:cloudinit" \
  --boot c --bootdisk scsi0 \
  --serial0 socket \
  --vga serial0 \
  --net0 virtio,bridge=vmbr0 \
  --ciuser packer \
  --searchdomain example.com

qm template "$VMID"

echo "Template $VMID ready for Packer"