#!/bin/bash

set -e

TEMPLATE_URL="https://cloud-images.ubuntu.com/plucky/current/plucky-server-cloudimg-amd64.img"
VMID=9000
TEMPLATE_NAME="ubuntu-25.04-cloudimg-temp"
STORAGE="local-lvm"


# Arguments positionnels d'abord (optional)
[ -n "$1" ] && VMID="$1"
[ -n "$2" ] && TEMPLATE_NAME="$2"
[ -n "$3" ] && STORAGE="$3"

# Puis arguments nommés override (optional)
while [[ $# -gt 4 ]]; do
    shift
    case "$1" in
        --vmid=*) VMID="${1#*=}" ;;
        --template=*) TEMPLATE_NAME="${1#*=}" ;;
        --storage=*) STORAGE="${1#*=}" ;;
    esac
done

cd /tmp
wget -O "${TEMPLATE_NAME}_disk" \
    "$TEMPLATE_URL"

qm create "$VMID" \
  --name "$TEMPLATE_NAME" \
  --memory 3072 \
  --cores 3 \
  --net0 virtio,bridge=vmbr0 \
  --serial0 socket \
  --vga serial0

qm importdisk "$VMID" "${TEMPLATE_NAME}_disk" "$STORAGE"

qm set "$VMID" \
  --scsihw virtio-scsi-pci \
  --scsi0 "${STORAGE}:vm-${VMID}-disk-0" \
  --ide2 "${STORAGE}:cloudinit" \
  --boot c --bootdisk scsi0 \
  --serial0 socket --vga serial0 \
  --net0 virtio,bridge=vmbr0

qm template "$VMID"

echo "Template $VMID ready for Packer"