#!bin/zsh

configure_systemd_resolved() {
    log_info "Configuration via systemd-resolved"
    
    # Créer le drop-in directory
    mkdir -p /etc/systemd/resolved.conf.d/
    
    # Écrire la config
    cat > /etc/systemd/resolved.conf.d/dns.conf <<EOF
[Resolve]
DNS=${DNS_SERVERS[@]}
FallbackDNS=1.1.1.1 8.8.8.8
Domains=${SEARCH_DOMAIN}
DNSSEC=no
DNSOverTLS=no
EOF

    # Restart service
    systemctl restart systemd-resolved
    
    if [[ ! -L /etc/resolv.conf ]]; then
        log_warn "/etc/resolv.conf n'est pas un symlink, correction..."
        rm -f /etc/resolv.conf
        ln -sf /run/systemd/resolve/stub-resolv.conf /etc/resolv.conf
    fi
    
    log_info "systemd-resolved configuré"
}