configure_static() {
    log_warn "Aucun gestionnaire détecté, configuration statique"
    
    # Désactiver immutabilité si présente
    chattr -i /etc/resolv.conf 2>/dev/null || true
    
    cp /etc/resolv.conf /etc/resolv.conf.backup.$(date +%s)
    
    cat > /etc/resolv.conf <<EOF
# Generated by custom DNS setup script
search ${SEARCH_DOMAIN}
$(for dns in "${DNS_SERVERS[@]}"; do echo "nameserver $dns"; done)
EOF

    # Rendre immutable pour éviter l'écrasement
    chattr +i /etc/resolv.conf
    
    log_info "Configuration statique appliquée (fichier verrouillé)"
}