#!bin/zsh

configure_interfaces() {
    log_info "Configuration via /etc/network/interfaces"
    
    cp /etc/network/interfaces /etc/network/interfaces.$(date +%s).bkp
    
    # Ajouter DNS si absent
    if ! grep -q "dns-nameservers" /etc/network/interfaces; then
        # Trouver l'interface principale
        main_iface=$(ip route | grep default | awk '{print $5}' | head -n1)
        
        if [[ -n $main_iface ]]; then
            DNS_JOIN="${DNS_SERVERS[*]}"
            # Ajouter après l'interface
            sed -i "/iface ${main_iface}/a \    dns-search ${SEARCH_DOMAIN}" /etc/network/interfaces
            sed -i "/iface ${main_iface}/a \    dns-nameservers ${DNS_JOIN}" /etc/network/interfaces
        fi
    else
        DNS_JOIN="${DNS_SERVERS[*]}"
        sed -i "s/dns-nameservers.*/dns-nameservers ${DNS_JOIN}/" /etc/network/interfaces
        sed -i "s/dns-search.*/dns-search ${SEARCH_DOMAIN}/" /etc/network/interfaces
    fi
    
    systemctl restart networking
    
    log_info "/etc/network/interfaces configuré"
}